// Generated by CoffeeScript 1.10.0
(function() {
  var AsyncDataFetcher, JobRunner, SearchEngines, SimpleCache, Utils, globalRoot, root,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    slice = [].slice;

  Utils = {
    getCurrentVersion: function() {
      return chrome.runtime.getManifest().version;
    },
    isExtensionPage: function() {
      var ref;
      return ((ref = document.location) != null ? ref.origin : void 0) + "/" === chrome.extension.getURL("");
    },
    isBackgroundPage: function() {
      return this.isExtensionPage() && chrome.extension.getBackgroundPage() === window;
    },
    invokeCommandString: function(str, argArray) {
      var component, components, func, k, len, obj, ref;
      components = str.split('.');
      obj = window;
      ref = components.slice(0, -1);
      for (k = 0, len = ref.length; k < len; k++) {
        component = ref[k];
        obj = obj[component];
      }
      func = obj[components.pop()];
      return func.apply(obj, argArray);
    },
    escapeRegexSpecialCharacters: (function() {
      var escapeRegex;
      escapeRegex = /[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;
      return function(str) {
        return str.replace(escapeRegex, "\\$&");
      };
    })(),
    escapeHtml: function(string) {
      return string.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    },
    createUniqueId: (function() {
      var id;
      id = 0;
      return function() {
        return id += 1;
      };
    })(),
    hasChromePrefix: (function() {
      var chromePrefixes;
      chromePrefixes = ["about:", "view-source:", "extension:", "chrome-extension:", "data:"];
      return function(url) {
        var k, len, prefix;
        for (k = 0, len = chromePrefixes.length; k < len; k++) {
          prefix = chromePrefixes[k];
          if (url.startsWith(prefix)) {
            return true;
          }
        }
        return false;
      };
    })(),
    hasJavascriptPrefix: function(url) {
      return url.startsWith("javascript:");
    },
    hasFullUrlPrefix: (function() {
      var urlPrefix;
      urlPrefix = new RegExp("^[a-z]{3,}://.");
      return function(url) {
        return urlPrefix.test(url);
      };
    })(),
    decodeURIByParts: function(uri) {
      return uri.split(/(?=%)/).map(function(uriComponent) {
        var error;
        try {
          return decodeURIComponent(uriComponent);
        } catch (error) {
          return uriComponent;
        }
      }).join("");
    },
    createFullUrl: function(partialUrl) {
      if (this.hasFullUrlPrefix(partialUrl)) {
        return partialUrl;
      } else {
        return "http://" + partialUrl;
      }
    },
    isUrl: function(str) {
      var dottedParts, hostName, lastPart, longTlds, match, ref, specialHostNames, urlRegex;
      if (indexOf.call(str, ' ') >= 0) {
        return false;
      }
      if (this.hasFullUrlPrefix(str)) {
        return true;
      }
      urlRegex = new RegExp('^(?:([^:]+)(?::([^:]+))?@)?' + '([^:]+|\\[[^\\]]+\\])' + '(?::(\\d+))?$');
      longTlds = ['arpa', 'asia', 'coop', 'info', 'jobs', 'local', 'mobi', 'museum', 'name', 'onion'];
      specialHostNames = ['localhost'];
      match = urlRegex.exec((str.split('/'))[0]);
      if (!match) {
        return false;
      }
      hostName = match[3];
      if (indexOf.call(specialHostNames, hostName) >= 0) {
        return true;
      }
      if (indexOf.call(hostName, ':') >= 0) {
        return true;
      }
      dottedParts = hostName.split('.');
      if (dottedParts.length > 1) {
        lastPart = dottedParts.pop();
        if ((2 <= (ref = lastPart.length) && ref <= 3) || indexOf.call(longTlds, lastPart) >= 0) {
          return true;
        }
      }
      if (/^(\d{1,3}\.){3}\d{1,3}$/.test(hostName)) {
        return true;
      }
      return false;
    },
    createSearchQuery: function(query) {
      if (typeof query === "string") {
        query = query.split(/\s+/);
      }
      return query.map(encodeURIComponent).join("+");
    },
    createSearchUrl: function(query, searchUrl) {
      if (searchUrl == null) {
        searchUrl = Settings.get("searchUrl");
      }
      if (!(0 <= searchUrl.indexOf("%s"))) {
        searchUrl += "%s";
      }
      return searchUrl.replace(/%s/g, this.createSearchQuery(query));
    },
    extractQuery: (function(_this) {
      return function() {
        var httpProtocolRegexp, queryTerminator;
        queryTerminator = new RegExp("[?&#/]");
        httpProtocolRegexp = new RegExp("^https?://");
        return function(searchUrl, url) {
          var error, k, len, ref, suffix, suffixTerms;
          url = url.replace(httpProtocolRegexp);
          searchUrl = searchUrl.replace(httpProtocolRegexp);
          ref = searchUrl.split("%s"), searchUrl = ref[0], suffixTerms = 2 <= ref.length ? slice.call(ref, 1) : [];
          if (!url.startsWith(searchUrl)) {
            return null;
          }
          for (k = 0, len = suffixTerms.length; k < len; k++) {
            suffix = suffixTerms[k];
            if (!(0 <= url.indexOf(suffix))) {
              return null;
            }
          }
          try {
            return url.slice(searchUrl.length).split(queryTerminator)[0].split("+").map(decodeURIComponent).join(" ");
          } catch (error) {
            return null;
          }
        };
      };
    })(this)(),
    convertToUrl: function(string) {
      string = string.trim();
      if (Utils.hasChromePrefix(string)) {
        return string;
      } else if (Utils.hasJavascriptPrefix(string)) {
        if (Utils.haveChromeVersion("46.0.2467.2")) {
          return string;
        } else {
          return Utils.decodeURIByParts(string);
        }
      } else if (Utils.isUrl(string)) {
        return Utils.createFullUrl(string);
      } else {
        return Utils.createSearchUrl(string);
      }
    },
    isString: function(obj) {
      return typeof obj === 'string' || obj instanceof String;
    },
    distinctCharacters: function(str) {
      var char, k, len, ref, unique;
      unique = "";
      ref = str.split("").sort();
      for (k = 0, len = ref.length; k < len; k++) {
        char = ref[k];
        if (!(0 <= unique.indexOf(char))) {
          unique += char;
        }
      }
      return unique;
    },
    compareVersions: function(versionA, versionB) {
      var a, b, i, k, ref;
      versionA = versionA.split(".");
      versionB = versionB.split(".");
      for (i = k = 0, ref = Math.max(versionA.length, versionB.length); 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        a = parseInt(versionA[i] || 0, 10);
        b = parseInt(versionB[i] || 0, 10);
        if (a < b) {
          return -1;
        } else if (a > b) {
          return 1;
        }
      }
      return 0;
    },
    haveChromeVersion: function(required) {
      var chromeVersion, ref;
      chromeVersion = (ref = navigator.appVersion.match(/Chrom(e|ium)\/(.*?) /)) != null ? ref[2] : void 0;
      return chromeVersion && 0 <= Utils.compareVersions(chromeVersion, required);
    },
    zip: function(arrays) {
      return arrays[0].map(function(_, i) {
        return arrays.map(function(array) {
          return array[i];
        });
      });
    },
    hasUpperCase: function(s) {
      return s.toLowerCase() !== s;
    },
    getIdentity: (function() {
      var identities;
      identities = [];
      return function(obj) {
        var index;
        index = identities.indexOf(obj);
        if (index < 0) {
          index = identities.length;
          identities.push(obj);
        }
        return "identity-" + index;
      };
    })(),
    copyObjectOmittingProperties: function() {
      var k, len, obj, properties, property;
      obj = arguments[0], properties = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      obj = extend({}, obj);
      for (k = 0, len = properties.length; k < len; k++) {
        property = properties[k];
        delete obj[property];
      }
      return obj;
    },
    matchesAnyRegexp: function(regexps, string) {
      var k, len, re;
      for (k = 0, len = regexps.length; k < len; k++) {
        re = regexps[k];
        if (re.test(string)) {
          return true;
        }
      }
      return false;
    },
    longestCommonPrefix: function(strings) {
      var ch, index, k, l, len, len1, ref, ref1, shortest, str;
      if (!(0 < strings.length)) {
        return 0;
      }
      strings.sort(function(a, b) {
        return a.length - b.length;
      });
      ref = strings, shortest = ref[0], strings = 2 <= ref.length ? slice.call(ref, 1) : [];
      ref1 = shortest.split("");
      for (index = k = 0, len = ref1.length; k < len; index = ++k) {
        ch = ref1[index];
        for (l = 0, len1 = strings.length; l < len1; l++) {
          str = strings[l];
          if (ch !== str[index]) {
            return index;
          }
        }
      }
      return shortest.length;
    },
    setTimeout: function(ms, func) {
      return setTimeout(func, ms);
    },
    nextTick: function(func) {
      return this.setTimeout(0, func);
    }
  };

  SearchEngines = {
    previousSearchEngines: null,
    searchEngines: null,
    refresh: function(searchEngines) {
      if (!((this.previousSearchEngines != null) && searchEngines === this.previousSearchEngines)) {
        this.previousSearchEngines = searchEngines;
        return this.searchEngines = new AsyncDataFetcher(function(callback) {
          var description, engines, k, keyword, len, line, ref, searchUrl, tokens;
          engines = {};
          ref = searchEngines.split("\n");
          for (k = 0, len = ref.length; k < len; k++) {
            line = ref[k];
            line = line.trim();
            if (/^[#"]/.test(line)) {
              continue;
            }
            tokens = line.split(/\s+/);
            if (!(2 <= tokens.length)) {
              continue;
            }
            keyword = tokens[0].split(":")[0];
            searchUrl = tokens[1];
            description = tokens.slice(2).join(" ") || ("search (" + keyword + ")");
            if (!Utils.hasFullUrlPrefix(searchUrl)) {
              continue;
            }
            engines[keyword] = {
              keyword: keyword,
              searchUrl: searchUrl,
              description: description
            };
          }
          return callback(engines);
        });
      }
    },
    use: function(callback) {
      return this.searchEngines.use(callback);
    },
    refreshAndUse: function(searchEngines, callback) {
      this.refresh(searchEngines);
      return this.use(callback);
    }
  };

  Function.prototype.curry = function() {
    var fixedArguments, fn;
    fixedArguments = Array.copy(arguments);
    fn = this;
    return function() {
      return fn.apply(this, fixedArguments.concat(Array.copy(arguments)));
    };
  };

  Array.copy = function(array) {
    return Array.prototype.slice.call(array, 0);
  };

  String.prototype.startsWith = function(str) {
    return this.indexOf(str) === 0;
  };

  String.prototype.ltrim = function() {
    return this.replace(/^\s+/, "");
  };

  String.prototype.rtrim = function() {
    return this.replace(/\s+$/, "");
  };

  globalRoot = typeof window !== "undefined" && window !== null ? window : global;

  globalRoot.extend = function(hash1, hash2) {
    var key;
    for (key in hash2) {
      hash1[key] = hash2[key];
    }
    return hash1;
  };

  SimpleCache = (function() {
    function SimpleCache(expiry, entries) {
      this.expiry = expiry != null ? expiry : 60 * 60 * 1000;
      this.entries = entries != null ? entries : 1000;
      this.cache = {};
      this.previous = {};
      this.lastRotation = new Date();
    }

    SimpleCache.prototype.has = function(key) {
      this.rotate();
      return (key in this.cache) || key in this.previous;
    };

    SimpleCache.prototype.set = function(key, value) {
      if (value == null) {
        value = null;
      }
      this.rotate();
      delete this.previous[key];
      if (value != null) {
        return this.cache[key] = value;
      } else {
        delete this.cache[key];
        return null;
      }
    };

    SimpleCache.prototype.get = function(key) {
      this.rotate();
      if (key in this.cache) {
        return this.cache[key];
      } else if (key in this.previous) {
        this.cache[key] = this.previous[key];
        delete this.previous[key];
        return this.cache[key];
      } else {
        return null;
      }
    };

    SimpleCache.prototype.rotate = function(force) {
      if (force == null) {
        force = false;
      }
      return Utils.nextTick((function(_this) {
        return function() {
          if (force || _this.entries < Object.keys(_this.cache).length || _this.expiry < new Date() - _this.lastRotation) {
            _this.lastRotation = new Date();
            _this.previous = _this.cache;
            return _this.cache = {};
          }
        };
      })(this));
    };

    SimpleCache.prototype.clear = function() {
      this.rotate(true);
      return this.rotate(true);
    };

    return SimpleCache;

  })();

  AsyncDataFetcher = (function() {
    function AsyncDataFetcher(fetch) {
      this.data = null;
      this.queue = [];
      Utils.nextTick((function(_this) {
        return function() {
          return fetch(function(data) {
            var callback, k, len, ref;
            _this.data = data;
            ref = _this.queue;
            for (k = 0, len = ref.length; k < len; k++) {
              callback = ref[k];
              callback(_this.data);
            }
            return _this.queue = null;
          });
        };
      })(this));
    }

    AsyncDataFetcher.prototype.use = function(callback) {
      if (this.data != null) {
        return callback(this.data);
      } else {
        return this.queue.push(callback);
      }
    };

    return AsyncDataFetcher;

  })();

  JobRunner = (function() {
    function JobRunner(jobs) {
      this.jobs = jobs;
      this.fetcher = new AsyncDataFetcher((function(_this) {
        return function(callback) {
          var job, k, len, ref, results;
          ref = _this.jobs;
          results = [];
          for (k = 0, len = ref.length; k < len; k++) {
            job = ref[k];
            results.push((function(job) {
              return Utils.nextTick(function() {
                return job(function() {
                  _this.jobs = _this.jobs.filter(function(j) {
                    return j !== job;
                  });
                  if (_this.jobs.length === 0) {
                    return callback(true);
                  }
                });
              });
            })(job));
          }
          return results;
        };
      })(this));
    }

    JobRunner.prototype.onReady = function(callback) {
      return this.fetcher.use(callback);
    };

    return JobRunner;

  })();

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Utils = Utils;

  root.SearchEngines = SearchEngines;

  root.SimpleCache = SimpleCache;

  root.AsyncDataFetcher = AsyncDataFetcher;

  root.JobRunner = JobRunner;

}).call(this);
